<?php

namespace Modules\GeneralSetting\Http\Controllers;


use Brian2694\Toastr\Facades\Toastr;
use Exception;
use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Illuminate\Support\Facades\Cache;
use Modules\GeneralSetting\Entities\BusinessSetting;
use Modules\UserActivityLog\Traits\LogActivity;

class CloudStorageController extends Controller
{
    public function index()
    {
        try{

            $data = [];
            $data['cloud_hosts'] = BusinessSetting::where('category_type','file_storage')->get();
            return view('generalsetting::cloud_storage_index',$data);
        }catch (\Exception $e) {
            LogActivity::errorLog($e->getMessage());
            Toastr::error(__('common.error_message'), __('common.error'));
            return back();
        }

    }

    public function allFileStorage()
    {
        return BusinessSetting::where('category_type','file_storage')->get();
    }

    public function activeStorage($activeStorageID)
    {
        foreach ($this->allFileStorage() as  $fileStore) {
            $fileStore->status = 0;
            $fileStore->save();
        }

        BusinessSetting::where('id',$activeStorageID)->update([
            'status' => 1,
        ]);

        $row = BusinessSetting::where('category_type','file_storage')->where('status',1)->first();
        if($row){
            Cache::forget('file_storage');
            Cache::rememberForever('file_storage', function () use($row) {
                return $row->type;
            });

        }else{
            Cache::rememberForever('file_storage', function ()  {
                return 'Local';
            });
        }

    }

    public function overWriteEnvFile($data)
    {
        try {
            foreach ($data as $key => $value) {
                putEnvConfigration($key, $value);
            }
            return true;
        } catch (Exception $e) {
            Toastr::error($e->getMessage(), 'Error!!');
            return back();
        }
    }

    public function store(Request $request)
    {
        $validate_rules = [
            'file_storage' =>'required',
        ];
        $request->validate($validate_rules, validationMessage($validate_rules));
        try{

            $this->activeStorage($request->file_storage);
            $this->overWriteEnvFile($request->except(['_token','file_storage']));
            Toastr::success(trans('common.updated_successfully'), trans('common.success'));
            return redirect()->back();
        }catch(Exception $e){
            Toastr::error($e->getMessage(), 'Error!!');
            return $e->getMessage();
        }

    }

}
