@extends('backEnd.master')
@section('styles')
<link rel="stylesheet" href="{{asset(asset_path('modules/customer/css/style.css'))}}" />

@endsection
@section('mainContent')

<section class="admin-visitor-area up_st_admin_visitor">

    <div class="container-fluid p-0">
        <div class="row">
            <div class="col-md-12 mb-20">
                <div class="box_header_right">
                    <div class="float-lg-right float-none pos_tab_btn justify-content-end">
                        <ul class="nav" role="tablist">

                            <li class="nav-item">
                                <a class="nav-link active show" href="#all_customer" role="tab" data-toggle="tab"
                                    id="1" aria-selected="true">{{ __('common.all') }} {{__('common.customer')}}</a>
                            </li>

                            <li class="nav-item">
                                <a class="nav-link" href="#active_customer" role="tab" data-toggle="tab"
                                    id="1" aria-selected="true">{{ __('common.active_customer') }}</a>
                            </li>
                            @if (permissionCheck('customer.list_inactive'))
                            <li class="nav-item">
                                <a class="nav-link" href="#in_active_customer" role="tab" data-toggle="tab" id="1"
                                    aria-selected="true">{{ __('common.in_active_customer') }}</a>
                            </li>
                            @endif

                            @if (permissionCheck('admin.customer.create'))
                            <li class="nav-item">
                                <a class="nav-link active" href="{{route('admin.customer.create')}}">{{ __('common.create') }} {{__('common.customer')}}</a>
                            </li>
                            @endif
                        </ul>
                    </div>
                </div>
            </div>
            <div class="col-xl-12">
                <div class="white_box_30px mb_30">
                    <div class="tab-content">

                        <div role="tabpanel" class="tab-pane fade active show" id="all_customer">
                            <div class="box_header common_table_header ">
                                <div class="main-title d-md-flex">
                                    <h3 class="mb-0 mr-30 mb_xs_15px mb_sm_20px">{{__('common.active_customer')}}</h3>
                                </div>
                            </div>
                            <div class="QA_section QA_section_heading_custom check_box_table">
                                <div class="QA_table">
                                    <!-- table-responsive -->
                                    <div class="">
                                        @include('customer::customers.components.all_lists')
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div role="tabpanel" class="tab-pane fade" id="active_customer">
                            <div class="box_header common_table_header ">
                                <div class="main-title d-md-flex">
                                    <h3 class="mb-0 mr-30 mb_xs_15px mb_sm_20px">{{__('common.active_customer')}}</h3>
                                </div>
                            </div>
                            <div class="QA_section QA_section_heading_custom check_box_table">
                                <div class="QA_table">
                                    <!-- table-responsive -->
                                    <div class="">
                                        @include('customer::customers.components.active_lists')
                                    </div>
                                </div>
                            </div>
                        </div>
                        @if (permissionCheck('customer.list_inactive'))
                        <div role="tabpanel" class="tab-pane fade" id="in_active_customer">
                            <div class="box_header common_table_header ">
                                <div class="main-title d-md-flex">
                                    <h3 class="mb-0 mr-30 mb_xs_15px mb_sm_20px">{{ __('common.in_active_customer') }}
                                    </h3>
                                </div>
                            </div>
                            <div class="QA_section QA_section_heading_custom check_box_table">
                                <div class="QA_table">
                                    <!-- table-responsive -->
                                    <div class="">
                                        @include('customer::customers.components.in_active_lists')
                                    </div>
                                </div>
                            </div>
                        </div>
                        @endif
                    </div>
                </div>
            </div>


        </div>
    </div>
    @include('backEnd.partials.delete_modal',['item_name' => __('common.customer')])
</section>
@endsection
@push('scripts')
    <script type="text/javascript">
        (function($){
                "use strict";

                $(document).ready(function(){
                    activeCustomerDataTable();
                    inactiveCustomerDataTable();
                    allCustomerDataTable();

                    $(document).on('click', '.delete_customer', function(event){
                        event.preventDefault();
                        let value = $(this).data('value');
                        confirm_modal(value);
                    });

                    $(document).on('change', '.update_active_status', function(event){
                        let id = $(this).data('id');
                        let status = 0;

                        if($(this).prop('checked')){
                            status = 1;
                        }
                        else{
                            status = 0;
                        }
                        $("#pre-loader").removeClass('d-none');

                        $.post('{{ route('customer.update_active_status') }}', {_token:'{{ csrf_token() }}', id:id, status:status}, function(data){
                            if(data == 1){
                                toastr.success("{{__('common.updated_successfully')}}","{{__('common.success')}}");
                                activeCustomerDataTable();
                                inactiveCustomerDataTable();
                            }
                            else{
                                toastr.error("{{__('common.error_message')}}","{{__('common.error')}}");
                            }
                            $("#pre-loader").addClass('d-none');
                        })

                        .fail(function(response) {
                                if(response.responseJSON.error){
                                        toastr.error(response.responseJSON.error ,"{{__('common.error')}}");
                                        $('#pre-loader').addClass('d-none');
                                        return false;
                                    }

                                });
                    });

                    function activeCustomerDataTable(){
                        $('#activeCustomerTable').DataTable({
                            processing: true,
                            serverSide: true,
                            stateSave: true,
                            "ajax": ( {
                                url: "{{ route('cusotmer.list.get-data') }}" + '?table=active_customer'
                            }),
                            "initComplete":function(json){

                            },
                            columns: [
                                { data: 'DT_RowIndex', name: 'id' ,render:function(data){
                                    return numbertrans(data)
                                }},
                                { data: 'avatar', name: 'avatar' },
                                { data: 'name', name: 'first_name' },
                                { data: 'email', name: 'email' },
                                { data: 'phone', name: 'username' },
                                { data: 'status', name: 'status' },
                                { data: 'wallet_balance', name: 'wallet_balance' },
                                { data: 'orders', name: 'orders' },
                                { data: 'action', name: 'action' }
                            ],

                            bLengthChange: false,
                            "bDestroy": true,
                            language: {
                                search: "<i class='ti-search'></i>",
                                searchPlaceholder: trans('common.quick_search'),
                                paginate: {
                                    next: "<i class='ti-arrow-right'></i>",
                                    previous: "<i class='ti-arrow-left'></i>"
                                }
                            },
                            dom: 'Bfrtip',
                            buttons: [{
                                    extend: 'copyHtml5',
                                    text: '<i class="fa fa-files-o"></i>',
                                    title: $("#header_title").text(),
                                    titleAttr: 'Copy',
                                    exportOptions: {
                                        columns: ':visible',
                                        columns: ':not(:last-child)',
                                    }
                                },
                                {
                                    extend: 'excelHtml5',
                                    text: '<i class="fa fa-file-excel-o"></i>',
                                    titleAttr: 'Excel',
                                    title: $("#header_title").text(),
                                    margin: [10, 10, 10, 0],
                                    exportOptions: {
                                        columns: ':visible',
                                        columns: ':not(:last-child)',
                                    },

                                },
                                {
                                    extend: 'csvHtml5',
                                    text: '<i class="fa fa-file-text-o"></i>',
                                    titleAttr: 'CSV',
                                    exportOptions: {
                                        columns: ':visible',
                                        columns: ':not(:last-child)',
                                    }
                                },
                                {
                                    extend: 'pdfHtml5',
                                    text: '<i class="fa fa-file-pdf-o"></i>',
                                    title: $("#header_title").text(),
                                    titleAttr: 'PDF',
                                    exportOptions: {
                                        columns: ':visible',
                                        columns: ':not(:last-child)',
                                    },
                                    pageSize: 'A4',
                                    margin: [0, 0, 0, 0],
                                    alignment: 'center',
                                    header: true,

                                },
                                {
                                    extend: 'print',
                                    text: '<i class="fa fa-print"></i>',
                                    titleAttr: 'Print',
                                    title: $("#header_title").text(),
                                    exportOptions: {
                                        columns: ':not(:last-child)',
                                    }
                                },
                                {
                                    extend: 'colvis',
                                    text: '<i class="fa fa-columns"></i>',
                                    postfixButtons: ['colvisRestore']
                                }
                            ],
                            columnDefs: [{
                                visible: false
                            }],
                            responsive: true,
                        });
                    }

                    function allCustomerDataTable(){
                        $('#allCustomerTable').DataTable({
                            processing: true,
                            serverSide: true,
                            stateSave: true,
                            "ajax": ( {
                                url: "{{ route('cusotmer.list.get-data') }}" + '?table=all_customer'
                            }),
                            "initComplete":function(json){

                            },
                            columns: [
                                { data: 'DT_RowIndex', name: 'id' ,render:function(data){
                                    return numbertrans(data)
                                }},
                                { data: 'avatar', name: 'avatar' },
                                { data: 'name', name: 'first_name' },
                                { data: 'email', name: 'email' },
                                { data: 'phone', name: 'username' },
                                { data: 'status', name: 'status' },
                                { data: 'wallet_balance', name: 'wallet_balance' },
                                { data: 'orders', name: 'orders' },
                                { data: 'action', name: 'action' }

                            ],

                            bLengthChange: false,
                            "bDestroy": true,
                            language: {
                                search: "<i class='ti-search'></i>",
                                searchPlaceholder: trans('common.quick_search'),
                                paginate: {
                                    next: "<i class='ti-arrow-right'></i>",
                                    previous: "<i class='ti-arrow-left'></i>"
                                }
                            },
                            dom: 'Bfrtip',
                            buttons: [{
                                    extend: 'copyHtml5',
                                    text: '<i class="fa fa-files-o"></i>',
                                    title: $("#header_title").text(),
                                    titleAttr: 'Copy',
                                    exportOptions: {
                                        columns: ':visible',
                                        columns: ':not(:last-child)',
                                    }
                                },
                                {
                                    extend: 'excelHtml5',
                                    text: '<i class="fa fa-file-excel-o"></i>',
                                    titleAttr: 'Excel',
                                    title: $("#header_title").text(),
                                    margin: [10, 10, 10, 0],
                                    exportOptions: {
                                        columns: ':visible',
                                        columns: ':not(:last-child)',
                                    },

                                },
                                {
                                    extend: 'csvHtml5',
                                    text: '<i class="fa fa-file-text-o"></i>',
                                    titleAttr: 'CSV',
                                    exportOptions: {
                                        columns: ':visible',
                                        columns: ':not(:last-child)',
                                    }
                                },
                                {
                                    extend: 'pdfHtml5',
                                    text: '<i class="fa fa-file-pdf-o"></i>',
                                    title: $("#header_title").text(),
                                    titleAttr: 'PDF',
                                    exportOptions: {
                                        columns: ':visible',
                                        columns: ':not(:last-child)',
                                    },
                                    pageSize: 'A4',
                                    margin: [0, 0, 0, 0],
                                    alignment: 'center',
                                    header: true,

                                },
                                {
                                    extend: 'print',
                                    text: '<i class="fa fa-print"></i>',
                                    titleAttr: 'Print',
                                    title: $("#header_title").text(),
                                    exportOptions: {
                                        columns: ':not(:last-child)',
                                    }
                                },
                                {
                                    extend: 'colvis',
                                    text: '<i class="fa fa-columns"></i>',
                                    postfixButtons: ['colvisRestore']
                                }
                            ],
                            columnDefs: [{
                                visible: false
                            }],
                            responsive: true,
                        });
                    }

                    function inactiveCustomerDataTable(){
                        $('#inactiveCustomerTable').DataTable({
                            processing: true,
                            serverSide: true,
                            stateSave: true,
                            "ajax": ( {
                                url: "{{ route('cusotmer.list.get-data') }}" + '?table=inactive_customer'
                            }),
                            "initComplete":function(json){

                            },
                            columns: [
                                { data: 'DT_RowIndex', name: 'id' ,render:function(data){
                                    return numbertrans(data)
                                }},
                                { data: 'avatar', name: 'avatar' },
                                { data: 'name', name: 'first_name' },
                                { data: 'email', name: 'email' },
                                { data: 'phone', name: 'username' },
                                { data: 'status', name: 'status' },
                                { data: 'wallet_balance', name: 'wallet_balance' },
                                { data: 'orders', name: 'orders' },
                                { data: 'action', name: 'action' }

                            ],

                            bLengthChange: false,
                            "bDestroy": true,
                            language: {
                                search: "<i class='ti-search'></i>",
                                searchPlaceholder: trans('common.quick_search'),
                                paginate: {
                                    next: "<i class='ti-arrow-right'></i>",
                                    previous: "<i class='ti-arrow-left'></i>"
                                }
                            },
                            dom: 'Bfrtip',
                            buttons: [{
                                    extend: 'copyHtml5',
                                    text: '<i class="fa fa-files-o"></i>',
                                    title: $("#header_title").text(),
                                    titleAttr: 'Copy',
                                    exportOptions: {
                                        columns: ':visible',
                                        columns: ':not(:last-child)',
                                    }
                                },
                                {
                                    extend: 'excelHtml5',
                                    text: '<i class="fa fa-file-excel-o"></i>',
                                    titleAttr: 'Excel',
                                    title: $("#header_title").text(),
                                    margin: [10, 10, 10, 0],
                                    exportOptions: {
                                        columns: ':visible',
                                        columns: ':not(:last-child)',
                                    },

                                },
                                {
                                    extend: 'csvHtml5',
                                    text: '<i class="fa fa-file-text-o"></i>',
                                    titleAttr: 'CSV',
                                    exportOptions: {
                                        columns: ':visible',
                                        columns: ':not(:last-child)',
                                    }
                                },
                                {
                                    extend: 'pdfHtml5',
                                    text: '<i class="fa fa-file-pdf-o"></i>',
                                    title: $("#header_title").text(),
                                    titleAttr: 'PDF',
                                    exportOptions: {
                                        columns: ':visible',
                                        columns: ':not(:last-child)',
                                    },
                                    pageSize: 'A4',
                                    margin: [0, 0, 0, 0],
                                    alignment: 'center',
                                    header: true,

                                },
                                {
                                    extend: 'print',
                                    text: '<i class="fa fa-print"></i>',
                                    titleAttr: 'Print',
                                    title: $("#header_title").text(),
                                    exportOptions: {
                                        columns: ':not(:last-child)',
                                    }
                                },
                                {
                                    extend: 'colvis',
                                    text: '<i class="fa fa-columns"></i>',
                                    postfixButtons: ['colvisRestore']
                                }
                            ],
                            columnDefs: [{
                                visible: false
                            }],
                            responsive: true,
                        });
                    }

                });
            })(jQuery);

    </script>
@endpush
